#pragma once

#include "html_tag.h"

namespace litehtml
{
    class el_text : public element
    {
    protected:
        tstring         m_text;
        tstring         m_transformed_text;
        size            m_size;
        text_transform  m_text_transform;
        bool            m_use_transformed;
        bool            m_draw_spaces;
    public:
        class Context {
        public:
            typedef Ref<Context> SharedPtr;

            virtual ~Context() {}
        private:
            DefineShareable()
        };

        el_text(const tchar_t* text, litehtml::document* doc);
        virtual ~el_text();

        virtual void                get_text(tstring& text) override;
        virtual const tchar_t*      get_style_property(const tchar_t* name, bool inherited, const tchar_t* def = 0) override;
        virtual const PropValue* GetStyleProperty(PropValue::Name name, bool inherited) override;
        virtual void                parse_styles(bool is_reparse) override;
        virtual int                 get_base_line() override;
        virtual void                draw(uint_ptr hdc, int x, int y, const position* clip) override;
        virtual int                 line_height() const override;
        virtual uint_ptr            get_font(font_metrics* fm = 0) override;
        virtual style_display       get_display() const override;
        virtual white_space         get_white_space() const override;
        virtual element_position    get_element_position(css_offsets* offsets = 0) const override;
        virtual css_offsets         get_css_offsets() const override;
        virtual bool                appendChild(const ptr& el) override;
        virtual bool                removeChild(const ptr& el) override;
        virtual size_t              get_children_count() const override;
        virtual element::ptr        get_child(int idx) const override;

        virtual void                get_content_size(size& sz, int max_width) override;

        // provides the text context
        const Context::SharedPtr&   GetContext();
        // provides the width of the element that is less or equal maxWidth but includes the last glyph completely
        int GetGlyphAlignedWidth(int maxWidth);

        int GetWidth() const;
        bool IsTruncation() const { return m_isTruncation; }
        void SetTruncation() { m_isTruncation = true; }

    protected:

    private:
        Context::SharedPtr m_context;
        bool m_isTruncation;
    };

inline
const el_text::Context::SharedPtr& el_text::GetContext()
{
    return m_context;
}

inline
int el_text::GetWidth() const
{
    return m_size.width;
}

inline
size_t el_text::get_children_count() const
{
   return m_children.size();
}

inline
litehtml::element::ptr el_text::get_child(int idx) const
{
   return m_children[idx];
}

}
